package cn.xisoil.aop;


import cn.xisoil.annotation.VisitIntercept;
import cn.xisoil.dao.AnalysisRepository;
import cn.xisoil.data.Analysis;
import cn.xisoil.sercvice.AnalysisInterface;
import cn.xisoil.utils.AnalysisUtils;
import cn.xisoil.utils.tool.HttpRequestIpUtils;
import cn.xisoil.utils.tool.SpringContextUtils;
import eu.bitwalker.useragentutils.UserAgent;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class AnalysisAsp {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SpringContextUtils springContextUtils;
    @Autowired
    private HttpRequestIpUtils httpRequestIpUtil;
    @Autowired
    private AnalysisRepository yueAnalysisRepository;
    @Autowired
    private AnalysisUtils analysisUtils;

    @Async
    public void analysis(JoinPoint point, VisitIntercept visitIntercept){
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        AnalysisInterface analysisInterface =springContextUtils.getBeanForType(visitIntercept.clazz());

//        String clientType = userAgent.getOperatingSystem().getDeviceType().toString();

        Analysis yueAnalysis = new Analysis();

        //ip
        String ip = httpRequestIpUtil.getIpAddress(httpServletRequest);
        yueAnalysis.setIp(ip);

        //设备浏览器
        UserAgent userAgent = UserAgent.parseUserAgentString(httpServletRequest.getHeader("user-agent"));
        String browser = userAgent.getBrowser().name();
        yueAnalysis.setBrowser(analysisUtils.getBrowser(browser));
        String os = userAgent.getOperatingSystem().name();
        yueAnalysis.setEquipment(analysisUtils.getEquipment(os));

        //栏目数据
        if (StringUtils.isNotBlank(visitIntercept.key())){
            yueAnalysis.setSectionName(visitIntercept.key());
        }
        else if (visitIntercept.args()>=0){
            Object[] tags= point.getArgs();
            if (ObjectUtils.isEmpty(tags)||tags.length< visitIntercept.args()){
                logger.warn("数据分析系统===>您指定了args为{}，传入参数数量为{}",visitIntercept.args(),tags.length);
            }
            else {
                yueAnalysis.setSectionName(analysisInterface.getName(tags[visitIntercept.args()-1]));
            }
        }
        else {
            yueAnalysis.setSectionName(analysisInterface.getName());
        }
        yueAnalysisRepository.save(yueAnalysis);
    }

}
