package cn.xisoil.aop;

import cn.xisoil.annotation.VisitIntercept;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component
@Aspect
public class VisitInterceptAsp {

    @Autowired
    private AnalysisAsp analysisAsp;

    @Before(value = "@annotation(visitIntercept)")
    public void systemLogin(JoinPoint point, VisitIntercept visitIntercept){
        RequestContextHolder.setRequestAttributes(RequestContextHolder.getRequestAttributes(), true);
        analysisAsp.analysis(point,visitIntercept);
    }

}
