package cn.xisoil.utils;

import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Component
public class DateUtils {


    public List<String> getDateList(){
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
//        LocalDate endDate = LocalDate.now().plusDays(1);
        LocalDate endDate = LocalDate.now();
        LocalDate startDate = endDate.minusDays(7);
        List<String>times=new ArrayList<>();
        List<LocalDate> listOfDates = startDate.datesUntil(endDate).toList();
        listOfDates.forEach(item->{
            times.add(dateTimeFormatter.format(item));
        });
        return times;
    }

    public List<String>getDateList(String startTime,String endTime) throws ParseException {

        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");

        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        LocalDate endDate =timeToLocal(simpleDateFormat.parse(endTime)).plusDays(1);
        LocalDate startDate = timeToLocal(simpleDateFormat.parse(startTime));

        List<String>times=new ArrayList<>();
        List<LocalDate> listOfDates = startDate.datesUntil(endDate).toList();
        listOfDates.forEach(item->{
            times.add(dateTimeFormatter.format(item));
        });
        return times;
    }

    public LocalDate timeToLocal(Date date){
        Instant instant =date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }


}
