package cn.xisoil.dao;

import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.SectionAnalysis;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Repository
public interface SectionAnalysisRepository extends YueRepository<SectionAnalysis,String> {

    Optional<SectionAnalysis>findTopByDateAndSectionName(String time, String sectionName);

    @Query(value = "select new map(sectionAnalysis.sectionName as sectionName,sum(sectionAnalysis.uvCount) as uvCount) " +
            " from SectionAnalysis sectionAnalysis group by sectionAnalysis.sectionName order by sum(sectionAnalysis.uvCount) desc")
    List<Map<String,Object>>findTop5SumBySectionName();


}
