package cn.xisoil.controller;


import cn.xisoil.annotation.log.Log;
import cn.xisoil.data.result.R;
import cn.xisoil.dto.AnalysisRequest;
import cn.xisoil.dto.StatisticalVo;
import cn.xisoil.sercvice.AnalysisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping("/manage/analysis")
public class AnalysisController {

    @Autowired
    private AnalysisService analysisService;

    @GetMapping("/equipment")
    @Log("获取设备访问信息")
    public R<AnalysisRequest> equipment(){
        return analysisService.equipment();
    }

    @GetMapping("/section")
    @Log("获取栏目访问信息")
    public R<AnalysisRequest> getSectionBar(){
        return analysisService.getSectionBar();
    }

    @GetMapping("/browser")
    @Log("获取浏览器访问信息")
    public R<AnalysisRequest> getBrowser(){
        return analysisService.getBrowser();
    }

    @GetMapping("/date")
    @Log("获取时间访问信息")
    public R<StatisticalVo> getDate(){
        return analysisService.getPVAndUV();
    }

}
