package cn.xisoil.data;

import cn.xisoil.annotation.model.CurdModelObject;
import jakarta.persistence.*;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import java.util.Date;

@Entity(name = "Analysis")
@Table(name = "v_analysis")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "访问日志")
public class Analysis {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    private String sectionName;

    @Enumerated(value = EnumType.STRING)
    private AnalysisBrowser browser;

    @Enumerated(value = EnumType.STRING)
    private AnalysisEquipment equipment;

    @CreatedDate
    private Date createTime;

    private String ip;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSectionName() {
        return sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public AnalysisBrowser getBrowser() {
        return browser;
    }

    public void setBrowser(AnalysisBrowser browser) {
        this.browser = browser;
    }

    public AnalysisEquipment getEquipment() {
        return equipment;
    }

    public void setEquipment(AnalysisEquipment equipment) {
        this.equipment = equipment;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}
