package cn.xisoil.dao;

import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.AnalysisEquipment;
import cn.xisoil.data.EquipmentAnalysis;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Repository
public interface EquipmentAnalysisRepository extends YueRepository<EquipmentAnalysis,String> {

    Optional<EquipmentAnalysis>findTopByDateAndEquipment(String time, AnalysisEquipment equipment);

    @Query(value = "select new map(equipment.equipment as name,sum(equipment.uvCount) as value)  from EquipmentAnalysis equipment group by equipment.equipment order by sum(equipment.uvCount) desc")
    List<Map<String,Object>> findTop5SumByEquipment();

}
