/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.sercvice.impl;

import cn.xisoil.dao.BrowserAnalysisRepository;
import cn.xisoil.dao.DateAnalysisRepository;
import cn.xisoil.dao.EquipmentAnalysisRepository;
import cn.xisoil.dao.SectionAnalysisRepository;
import cn.xisoil.data.DateAnalysis;
import cn.xisoil.data.result.R;
import cn.xisoil.dto.AnalysisRequest;
import cn.xisoil.dto.StatisticalVo;
import cn.xisoil.sercvice.AnalysisService;
import cn.xisoil.utils.DateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnalysisServiceImpl
implements AnalysisService {
    @Autowired
    private SectionAnalysisRepository sectionAnalysisRepository;
    @Autowired
    private EquipmentAnalysisRepository equipmentAnalysisRepository;
    @Autowired
    private BrowserAnalysisRepository browserAnalysisRepository;
    @Autowired
    private DateUtils dateUtils;
    @Autowired
    private DateAnalysisRepository dateAnalysisRepository;

    @Override
    public R<AnalysisRequest> getSectionBar() {
        List<Map<String, Object>> mapList = this.sectionAnalysisRepository.findTop5SumBySectionName();
        AnalysisRequest analysisRequest = new AnalysisRequest();
        analysisRequest.setList(mapList);
        AtomicInteger count = new AtomicInteger();
        mapList.forEach(map -> count.set(count.get() + Integer.parseInt(map.get("uvCount").toString())));
        analysisRequest.setCount(count.get());
        return R.builder().success().data((Object)analysisRequest).build();
    }

    @Override
    public R<AnalysisRequest> equipment() {
        List<Map<String, Object>> mapList = this.equipmentAnalysisRepository.findTop5SumByEquipment();
        AnalysisRequest analysisRequest = new AnalysisRequest();
        analysisRequest.setList(mapList);
        AtomicInteger count = new AtomicInteger();
        mapList.forEach(map -> count.set(count.get() + Integer.parseInt(map.get("value").toString())));
        analysisRequest.setCount(count.get());
        return R.builder().success().data((Object)analysisRequest).build();
    }

    @Override
    public R<AnalysisRequest> getBrowser() {
        List<Map<String, Object>> mapList = this.browserAnalysisRepository.findTop5SumByBrowser();
        AnalysisRequest analysisRequest = new AnalysisRequest();
        analysisRequest.setList(mapList);
        AtomicInteger count = new AtomicInteger();
        mapList.forEach(map -> count.set(count.get() + Integer.parseInt(map.get("value").toString())));
        analysisRequest.setCount(count.get());
        return R.builder().success().data((Object)analysisRequest).build();
    }

    @Override
    public R<StatisticalVo> getPVAndUV() {
        StatisticalVo statisticalVo = new StatisticalVo();
        List<String> times = this.dateUtils.getDateList();
        statisticalVo.setTimes(times);
        Map<String, DateAnalysis> yueDateAnalysisList = this.dateAnalysisRepository.findAllByDateIn(times).stream().collect(Collectors.toMap(DateAnalysis::getDate, v -> v, (v1, v2) -> v2));
        ArrayList<Integer> pvCounts = new ArrayList<Integer>();
        ArrayList<Integer> uvCounts = new ArrayList<Integer>();
        times.forEach(time -> {
            pvCounts.add(yueDateAnalysisList.getOrDefault(time, new DateAnalysis()).getPvCount());
            uvCounts.add(yueDateAnalysisList.getOrDefault(time, new DateAnalysis()).getUvCount());
        });
        statisticalVo.setPvCount(pvCounts);
        statisticalVo.setUvCount(uvCounts);
        return R.builder().success().data((Object)statisticalVo).build();
    }
}

