/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.aop;

import cn.xisoil.dao.AnalysisRepository;
import cn.xisoil.dao.BrowserAnalysisRepository;
import cn.xisoil.dao.DateAnalysisRepository;
import cn.xisoil.dao.EquipmentAnalysisRepository;
import cn.xisoil.dao.SectionAnalysisRepository;
import cn.xisoil.data.Analysis;
import cn.xisoil.data.AnalysisBrowser;
import cn.xisoil.data.AnalysisEquipment;
import cn.xisoil.data.BrowserAnalysis;
import cn.xisoil.data.DateAnalysis;
import cn.xisoil.data.EquipmentAnalysis;
import cn.xisoil.data.SectionAnalysis;
import cn.xisoil.utils.TaskService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="\u6570\u636e\u5206\u6790")
public class AnalysisTaskUtils
extends TaskService {
    @Autowired
    private AnalysisRepository analysisRepository;
    @Autowired
    private BrowserAnalysisRepository browserAnalysisRepository;
    @Autowired
    private SectionAnalysisRepository sectionAnalysisRepository;
    @Autowired
    private EquipmentAnalysisRepository equipmentAnalysisRepository;
    @Autowired
    private DateAnalysisRepository dateAnalysisRepository;

    public AnalysisTaskUtils() {
        super("0 0 1 * * ?");
    }

    public String getTaskName() {
        return "\u6570\u636e\u5206\u6790";
    }

    public void run() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = simpleDateFormat.format(this.getYesterday());
        List<Analysis> yueAnalyses = this.analysisRepository.findAllByToday(date);
        Map<AnalysisEquipment, List<Analysis>> analysisEquipments = yueAnalyses.stream().collect(Collectors.groupingBy(Analysis::getEquipment));
        analysisEquipments.forEach((analysisEquipment, analyses) -> {
            EquipmentAnalysis equipmentAnalysis = this.equipmentAnalysisRepository.findTopByDateAndEquipment(date, (AnalysisEquipment)((Object)analysisEquipment)).orElse(new EquipmentAnalysis());
            equipmentAnalysis.setEquipment((AnalysisEquipment)((Object)analysisEquipment));
            equipmentAnalysis.setDate(date);
            equipmentAnalysis.setPvCount(equipmentAnalysis.getPvCount() + analyses.size());
            equipmentAnalysis.setUvCount(equipmentAnalysis.getUvCount() + analyses.stream().collect(Collectors.groupingBy(Analysis::getIp)).size());
            this.equipmentAnalysisRepository.save(equipmentAnalysis);
        });
        Map<AnalysisBrowser, List<Analysis>> analysisBrowsers = yueAnalyses.stream().collect(Collectors.groupingBy(Analysis::getBrowser));
        analysisBrowsers.forEach((analysisBrowser, analyses) -> {
            BrowserAnalysis browserAnalysis = this.browserAnalysisRepository.findTopByDateAndBrowser(date, (AnalysisBrowser)((Object)analysisBrowser)).orElse(new BrowserAnalysis());
            browserAnalysis.setBrowser((AnalysisBrowser)((Object)analysisBrowser));
            browserAnalysis.setDate(date);
            browserAnalysis.setPvCount(browserAnalysis.getPvCount() + analyses.size());
            browserAnalysis.setUvCount(browserAnalysis.getUvCount() + analyses.stream().collect(Collectors.groupingBy(Analysis::getIp)).size());
            this.browserAnalysisRepository.save(browserAnalysis);
        });
        Map<String, List<Analysis>> analysisSections = yueAnalyses.stream().collect(Collectors.groupingBy(Analysis::getSectionName));
        analysisSections.forEach((analysisSection, analyses) -> {
            SectionAnalysis sectionAnalysis = this.sectionAnalysisRepository.findTopByDateAndSectionName(date, (String)analysisSection).orElse(new SectionAnalysis());
            sectionAnalysis.setSectionName((String)analysisSection);
            sectionAnalysis.setDate(date);
            sectionAnalysis.setPvCount(sectionAnalysis.getPvCount() + analyses.size());
            sectionAnalysis.setUvCount(sectionAnalysis.getUvCount() + analyses.stream().collect(Collectors.groupingBy(Analysis::getIp)).size());
            this.sectionAnalysisRepository.save(sectionAnalysis);
        });
        DateAnalysis dateAnalysis = this.dateAnalysisRepository.findTopByDate(date).orElse(new DateAnalysis());
        dateAnalysis.setDate(date);
        dateAnalysis.setPvCount(yueAnalyses.size());
        dateAnalysis.setUvCount(yueAnalyses.stream().collect(Collectors.groupingBy(Analysis::getIp)).size());
        this.dateAnalysisRepository.save(dateAnalysis);
        this.analysisRepository.deleteAll(yueAnalyses);
    }

    private Date getYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return cal.getTime();
    }
}

