package cn.xisoil.data;

import cn.xisoil.annotation.model.CurdModelObject;
import jakarta.persistence.*;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;



@Entity(name = "BrowserAnalysis")
@Table(name = "v_browser_analysis")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "浏览器访问日志")
public class BrowserAnalysis {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @Enumerated(value = EnumType.STRING)
    private AnalysisBrowser browser;

    private String date;

    private Integer pvCount=0;

    private Integer uvCount=0;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AnalysisBrowser getBrowser() {
        return browser;
    }

    public void setBrowser(AnalysisBrowser browser) {
        this.browser = browser;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Integer getPvCount() {
        return pvCount;
    }

    public void setPvCount(Integer pvCount) {
        this.pvCount = pvCount;
    }

    public Integer getUvCount() {
        return uvCount;
    }

    public void setUvCount(Integer uvCount) {
        this.uvCount = uvCount;
    }
}
