package cn.xisoil.aop;

import cn.xisoil.dao.*;
import cn.xisoil.data.*;
import cn.xisoil.utils.TaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("数据分析")
public class AnalysisTaskUtils extends TaskService {

    @Autowired
    private AnalysisRepository analysisRepository;
    @Autowired
    private BrowserAnalysisRepository browserAnalysisRepository;
    @Autowired
    private SectionAnalysisRepository sectionAnalysisRepository;
    @Autowired
    private EquipmentAnalysisRepository equipmentAnalysisRepository;
    @Autowired
    private DateAnalysisRepository dateAnalysisRepository;

    public AnalysisTaskUtils() {
        super("0 0 1 * * ?");
    }

    @Override
    public String getTaskName() {
        return "数据分析";
    }


    @Override
    public void run() {

        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");
        String date=simpleDateFormat.format(getYesterday());
        List<Analysis>yueAnalyses= analysisRepository.findAllByToday(date);

        //设备
        Map<AnalysisEquipment, List<Analysis>> analysisEquipments=yueAnalyses.stream().collect(Collectors.groupingBy(Analysis::getEquipment));
        analysisEquipments.forEach(((analysisEquipment, analyses) -> {
            EquipmentAnalysis equipmentAnalysis = equipmentAnalysisRepository.findTopByDateAndEquipment(date,analysisEquipment)
                    .orElse(new EquipmentAnalysis());
            equipmentAnalysis.setEquipment(analysisEquipment);
            equipmentAnalysis.setDate(date);
            equipmentAnalysis.setPvCount(equipmentAnalysis.getPvCount()+analyses.size());
            equipmentAnalysis.setUvCount(equipmentAnalysis.getUvCount()+analyses.stream().collect(Collectors.groupingBy(Analysis::getIp)).size());
            equipmentAnalysisRepository.save(equipmentAnalysis);
        }));

        //浏览器
        Map<AnalysisBrowser,List<Analysis>>analysisBrowsers=yueAnalyses.stream().collect(Collectors.groupingBy(Analysis::getBrowser));
        analysisBrowsers.forEach(((analysisBrowser, analyses) -> {
            BrowserAnalysis browserAnalysis = browserAnalysisRepository.findTopByDateAndBrowser(date,analysisBrowser)
                    .orElse(new BrowserAnalysis());
            browserAnalysis.setBrowser(analysisBrowser);
            browserAnalysis.setDate(date);
            browserAnalysis.setPvCount(browserAnalysis.getPvCount()+analyses.size());
            browserAnalysis.setUvCount(browserAnalysis.getUvCount()+analyses.stream().collect(Collectors.groupingBy(Analysis::getIp)).size());
            browserAnalysisRepository.save(browserAnalysis);
        }));

        //栏目
        Map<String,List<Analysis>>analysisSections=yueAnalyses.stream().collect(Collectors.groupingBy(Analysis::getSectionName));
        analysisSections.forEach(((analysisSection, analyses) -> {
            SectionAnalysis sectionAnalysis = sectionAnalysisRepository.findTopByDateAndSectionName(date,analysisSection)
                    .orElse(new SectionAnalysis());
            sectionAnalysis.setSectionName(analysisSection);
            sectionAnalysis.setDate(date);
            sectionAnalysis.setPvCount(sectionAnalysis.getPvCount()+analyses.size());
            sectionAnalysis.setUvCount(sectionAnalysis.getUvCount()+analyses.stream().collect(Collectors.groupingBy(Analysis::getIp)).size());
            sectionAnalysisRepository.save(sectionAnalysis);
        }));

        //时间PV/UV
        DateAnalysis dateAnalysis = dateAnalysisRepository.findTopByDate(date).orElse(new DateAnalysis());
        dateAnalysis.setDate(date);
        dateAnalysis.setPvCount(yueAnalyses.size());
        dateAnalysis.setUvCount(yueAnalyses.stream().collect(Collectors.groupingBy(Analysis::getIp)).size());
        dateAnalysisRepository.save(dateAnalysis);

        analysisRepository.deleteAll(yueAnalyses);

    }

    private Date getYesterday(){
        Calendar cal   =   Calendar.getInstance();
        cal.add(Calendar.DATE,   -1);
        return  cal.getTime();
    }

}
