/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DateUtils {
    public List<String> getDateList() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate endDate = LocalDate.now();
        LocalDate startDate = endDate.minusDays(7L);
        ArrayList<String> times = new ArrayList<String>();
        List<LocalDate> listOfDates = startDate.datesUntil(endDate).toList();
        listOfDates.forEach(item -> times.add(dateTimeFormatter.format((TemporalAccessor)item)));
        return times;
    }

    public List<String> getDateList(String startTime, String endTime) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate endDate = this.timeToLocal(simpleDateFormat.parse(endTime)).plusDays(1L);
        LocalDate startDate = this.timeToLocal(simpleDateFormat.parse(startTime));
        ArrayList<String> times = new ArrayList<String>();
        List<LocalDate> listOfDates = startDate.datesUntil(endDate).toList();
        listOfDates.forEach(item -> times.add(dateTimeFormatter.format((TemporalAccessor)item)));
        return times;
    }

    public LocalDate timeToLocal(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }
}

