package cn.xisoil.sercvice.impl;

import cn.xisoil.dao.BrowserAnalysisRepository;
import cn.xisoil.dao.DateAnalysisRepository;
import cn.xisoil.dao.EquipmentAnalysisRepository;
import cn.xisoil.dao.SectionAnalysisRepository;
import cn.xisoil.data.DateAnalysis;
import cn.xisoil.data.result.R;
import cn.xisoil.dto.AnalysisRequest;
import cn.xisoil.dto.StatisticalVo;
import cn.xisoil.sercvice.AnalysisService;
import cn.xisoil.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@Service
public class AnalysisServiceImpl implements AnalysisService {

    @Autowired
    private SectionAnalysisRepository sectionAnalysisRepository;
    @Autowired
    private EquipmentAnalysisRepository equipmentAnalysisRepository;
    @Autowired
    private BrowserAnalysisRepository browserAnalysisRepository;
    @Autowired
    private DateUtils dateUtils;
    @Autowired
    private DateAnalysisRepository dateAnalysisRepository;

    @Override
    public R<AnalysisRequest> getSectionBar() {
        List<Map<String, Object>> mapList=sectionAnalysisRepository.findTop5SumBySectionName();
        AnalysisRequest analysisRequest=new AnalysisRequest();
        analysisRequest.setList(mapList);
        AtomicInteger count= new AtomicInteger();
        mapList.forEach(map -> {
            count.set(count.get() + Integer.parseInt(map.get("uvCount").toString()));
        });
        analysisRequest.setCount(count.get());
        return R.<AnalysisRequest>builder().success().data(analysisRequest).build();
    }

    @Override
    public R<AnalysisRequest> equipment() {
        List<Map<String, Object>> mapList=equipmentAnalysisRepository.findTop5SumByEquipment();
        AnalysisRequest analysisRequest=new AnalysisRequest();
        analysisRequest.setList(mapList);
        AtomicInteger count= new AtomicInteger();
        mapList.forEach(map -> {
            count.set(count.get() + Integer.parseInt(map.get("value").toString()));
        });
        analysisRequest.setCount(count.get());
        return R.<AnalysisRequest>builder().success().data(analysisRequest).build();
    }

    @Override
    public R<AnalysisRequest> getBrowser() {
        List<Map<String, Object>> mapList=browserAnalysisRepository.findTop5SumByBrowser();
        AnalysisRequest analysisRequest=new AnalysisRequest();
        analysisRequest.setList(mapList);
        AtomicInteger count= new AtomicInteger();
        mapList.forEach(map -> {
            count.set(count.get() + Integer.parseInt(map.get("value").toString()));
        });
        analysisRequest.setCount(count.get());
        return R.<AnalysisRequest>builder().success().data(analysisRequest).build();
    }

    @Override
    public R<StatisticalVo> getPVAndUV() {
        StatisticalVo statisticalVo=new StatisticalVo();
        List<String> times=dateUtils.getDateList();
        statisticalVo.setTimes(times);

        Map<String, DateAnalysis>yueDateAnalysisList= dateAnalysisRepository.findAllByDateIn(times).stream()
                .collect(Collectors.toMap(DateAnalysis::getDate, v->v,(v1, v2)->v2));;

        List<Integer>pvCounts=new ArrayList<>();
        List<Integer>uvCounts=new ArrayList<>();

        times.forEach(time->{
            pvCounts.add(yueDateAnalysisList.getOrDefault(time,new DateAnalysis()).getPvCount());
            uvCounts.add(yueDateAnalysisList.getOrDefault(time,new DateAnalysis()).getUvCount());
        });

        statisticalVo.setPvCount(pvCounts);
        statisticalVo.setUvCount(uvCounts);

        return R.<StatisticalVo>builder().success().data(statisticalVo).build();
    }
}
