package cn.xisoil.dao;

import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.AnalysisBrowser;
import cn.xisoil.data.BrowserAnalysis;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Repository
public interface BrowserAnalysisRepository extends YueRepository<BrowserAnalysis,String> {

    Optional<BrowserAnalysis>findTopByDateAndBrowser(String time, AnalysisBrowser browser);



    @Query(value = "select new map(browser.browser as name,sum(browser.uvCount) as value)  from BrowserAnalysis browser group by browser.browser order by sum(browser.uvCount) desc ")
    List<Map<String,Object>> findTop5SumByBrowser();



}
