/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.aop;

import cn.xisoil.annotation.VisitIntercept;
import cn.xisoil.dao.AnalysisRepository;
import cn.xisoil.data.Analysis;
import cn.xisoil.sercvice.AnalysisInterface;
import cn.xisoil.utils.AnalysisUtils;
import cn.xisoil.utils.HttpRequestIpUtils;
import cn.xisoil.utils.SpringContextUtils;
import eu.bitwalker.useragentutils.UserAgent;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class AnalysisAsp {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SpringContextUtils springContextUtils;
    @Autowired
    private HttpRequestIpUtils httpRequestIpUtil;
    @Autowired
    private AnalysisRepository yueAnalysisRepository;
    @Autowired
    private AnalysisUtils analysisUtils;

    @Async
    public void analysis(JoinPoint point, VisitIntercept visitIntercept) {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        AnalysisInterface analysisInterface = (AnalysisInterface)this.springContextUtils.getBeanForType(visitIntercept.clazz());
        Analysis yueAnalysis = new Analysis();
        String ip = this.httpRequestIpUtil.getIpAddress(httpServletRequest);
        yueAnalysis.setIp(ip);
        UserAgent userAgent = UserAgent.parseUserAgentString((String)httpServletRequest.getHeader("user-agent"));
        String browser = userAgent.getBrowser().name();
        yueAnalysis.setBrowser(this.analysisUtils.getBrowser(browser));
        String os = userAgent.getOperatingSystem().name();
        yueAnalysis.setEquipment(this.analysisUtils.getEquipment(os));
        if (StringUtils.isNotBlank((CharSequence)visitIntercept.key())) {
            yueAnalysis.setSectionName(visitIntercept.key());
        } else if (visitIntercept.args() >= 0) {
            Object[] tags = point.getArgs();
            if (ObjectUtils.isEmpty((Object)tags) || tags.length < visitIntercept.args()) {
                this.logger.warn("\u6570\u636e\u5206\u6790\u7cfb\u7edf===>\u60a8\u6307\u5b9a\u4e86args\u4e3a{}\uff0c\u4f20\u5165\u53c2\u6570\u6570\u91cf\u4e3a{}", (Object)visitIntercept.args(), (Object)tags.length);
            } else {
                yueAnalysis.setSectionName(analysisInterface.getName(tags[visitIntercept.args() - 1]));
            }
        } else {
            yueAnalysis.setSectionName(analysisInterface.getName());
        }
        this.yueAnalysisRepository.save(yueAnalysis);
    }
}

