package cn.xisoil.file.data;


import cn.xisoil.curd.model.enums.ObjectColumnType;
import cn.xisoil.curd.model.interfaces.CurdModel;
import cn.xisoil.curd.model.interfaces.CurdModelObject;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import jakarta.persistence.*;

@Data
@Entity(name = "YueFileConfig")
@Table(name = "yue_file_config")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "文件管理",add = false,edit = false)
public class YueFileConfig {


    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @Enumerated(value = EnumType.STRING)
    @CurdModel(value = "存储方式",type = ObjectColumnType.LIST,url = "/file/config/type")
    private UPLOADTYPE uploadtype=UPLOADTYPE.LOCAL;

    @CurdModel(value = "文件节点")
    private String endpoint="https://oss-cn-hangzhou.aliyuncs.com";

    @CurdModel(value = "KEY ID")
    private String accessKeyId;

    @CurdModel(value = "密钥")
    private String accessKeySecret;

    @CurdModel(value = "通道名称")
    private String bucketName="default";

}
