package cn.xisoil.curd.model.controller;

import cn.xisoil.common.result.YueResult;
import cn.xisoil.curd.dao.YueRepository;
import cn.xisoil.curd.model.data.YueModelClassData;
import cn.xisoil.curd.model.data.YueModelColumns;
import cn.xisoil.curd.model.enums.ObjectType;
import cn.xisoil.curd.model.service.single.SingleDaoServiceImpl;
import cn.xisoil.curd.model.service.yueModel.YueModelService;
import cn.xisoil.datacheck.PermissionCheckAutomation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import jakarta.validation.Valid;
import java.lang.reflect.ParameterizedType;
import java.util.List;

public abstract class SingleModelController<T,R extends YueRepository<T,String>> extends SingleDaoServiceImpl<T,R> implements PermissionCheckAutomation<T> {

    @Autowired
    private YueModelService yueModelService;

    @GetMapping("/columns")
    public YueResult<YueModelClassData> getFieldsDec() {
        Class<T> clazz = (Class<T>)((ParameterizedType)getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        YueModelClassData yueModelClass=yueModelService.getYueClass(clazz);
        yueModelClass.setType(ObjectType.SINGLE);
        List<YueModelColumns> yueModelColumnsList=yueModelService.getYueColumns(clazz);
        yueModelClass.setColumns(yueModelColumnsList);
        return YueResult.<YueModelClassData>builder().data(yueModelClass).success().message("获取成功").build();
    }

    @GetMapping("")
    public YueResult<T>get(){
        return super.get();
    }

    @PutMapping("")
    public YueResult<String>edit(@Valid  @RequestBody T r, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.edit(r);
    }

}
