package cn.xisoil.curd.model.controller;

import cn.xisoil.common.to.ListStringRequest;
import cn.xisoil.common.to.SearchPageRequest;
import cn.xisoil.common.result.YueResult;
import cn.xisoil.curd.model.data.YueModelClassData;
import cn.xisoil.curd.model.data.YueModelColumns;
import cn.xisoil.curd.model.enums.ObjectType;
import cn.xisoil.curd.model.service.list.CurdDaoServiceImpl;
import cn.xisoil.curd.model.service.yueModel.YueModelService;
import cn.xisoil.curd.dao.YueRepository;
import cn.xisoil.datacheck.PermissionCheckAutomation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.Valid;

import java.util.*;


public abstract class ModelCurdController<T,R extends YueRepository<T,String>> extends CurdDaoServiceImpl<T,R> implements PermissionCheckAutomation<T> {

    @Autowired
    private YueModelService yueModelService;



    @GetMapping("/columns")
    public YueResult<YueModelClassData> getFieldsDec() {
        YueModelClassData yueModelClass=yueModelService.getYueClass(super.getGenericClass());
        List<YueModelColumns>yueModelColumnsList=yueModelService.getYueColumns(super.getGenericClass());
        yueModelClass.setType(ObjectType.LIST);
        yueModelClass.setColumns(yueModelColumnsList);
        return YueResult.<YueModelClassData>builder().data(yueModelClass).success().message("获取成功").build();
    }


    public YueResult<Page<T>> page(@Valid @RequestBody SearchPageRequest searchPageRequest,BindingResult result) {
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<Page<T>>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.page(searchPageRequest);
    }

    public YueResult<List<T>> list() {
        return super.list();
    }

    public YueResult<List<T>> search(String keyword,String id) {
        return super.search(keyword,id);
    }

    protected YueResult<String> delete(ListStringRequest stringRequest, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return  super.delete(stringRequest);
    }

    public YueResult<String>edit( T request,BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.edit(request);
    }

    protected  YueResult<String>add(@Valid @RequestBody T request,BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.add(request);
    }

    public YueResult<T>get(@PathVariable String id){
        return super.get(id);
    }

}
