package cn.xisoil.curd.model.controller;

import cn.xisoil.common.result.YueResult;
import cn.xisoil.curd.model.data.YueModelClassData;
import cn.xisoil.curd.model.data.YueModelColumns;
import cn.xisoil.curd.model.enums.ObjectType;
import cn.xisoil.curd.model.service.yueModel.YueModelService;
import cn.xisoil.datacheck.PermissionCheckAutomation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.ParameterizedType;
import java.util.List;


public abstract class ModelController<T> implements PermissionCheckAutomation<T> {

    @Autowired
    private YueModelService yueModelService;

    @GetMapping("/columns")
    public YueResult<YueModelClassData> getFieldsDec() {
        Class<T> clazz = (Class<T>)((ParameterizedType)getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        YueModelClassData yueModelClass=yueModelService.getYueClass(clazz);
        yueModelClass.setType(ObjectType.LIST);
        List<YueModelColumns>yueModelColumnsList=yueModelService.getYueColumns(clazz);
        yueModelClass.setColumns(yueModelColumnsList);
        return YueResult.<YueModelClassData>builder().data(yueModelClass).success().message("获取成功").build();
    }


}
