package cn.xisoil.wallet.data;

import cn.xisoil.curd.model.enums.YueColumnsType;
import cn.xisoil.curd.model.interfaces.CurdModel;
import cn.xisoil.curd.model.interfaces.CurdModelObject;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import jakarta.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

@Data
@Entity(name = "YuePayMall")
@Table(name = "yue_pay_mall")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(name = "充值管理")
public class YuePayMall {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "获取积分")
    private BigDecimal price;

    @CurdModel(value = "添加时间",comparable = true,type = YueColumnsType.TIME,editor = false)
    @CreatedDate
    private Date createTime;

    @CurdModel(value = "支付积分")
    private BigDecimal payPrice;

}
