package cn.xisoil.wallet.controller;

import cn.xisoil.common.result.YueResult;
import cn.xisoil.common.to.SearchPageRequest;
import cn.xisoil.curd.model.controller.ModelCurdControllerMapping;
import cn.xisoil.wallet.dao.YueOrderRepository;
import cn.xisoil.wallet.data.YueOrder;
import cn.xisoil.wallet.service.YueOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/manage/userinfo/order")
public class CurdUserInfoOrderController extends ModelCurdControllerMapping<YueOrder, YueOrderRepository> {

    @Autowired
    private YueOrderService yueOrderService;

    @PostMapping("/page")
    public YueResult<Page<YueOrder>> page(@Valid @RequestBody SearchPageRequest searchPageRequest, BindingResult result) {
        if (result.hasErrors()) {
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<Page<YueOrder>>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return yueOrderService.page(searchPageRequest);
    }

}
