package cn.xisoil.wallet.controller;

import cn.xisoil.common.result.YueResult;
import cn.xisoil.curd.model.controller.ModelCurdControllerMapping;
import cn.xisoil.wallet.dao.YueOrderRepository;
import cn.xisoil.wallet.data.YueOrder;
import cn.xisoil.wallet.service.YueOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/manage/order")
public class CurdOrderController extends ModelCurdControllerMapping<YueOrder, YueOrderRepository> {

    @Autowired
    private YueOrderService yueOrderService;

    @GetMapping("/type/list")
    public YueResult<List<Map<String, String>>> getType() {
        List<Map<String, String>> mapList = new ArrayList<>();
        mapList.add(Map.of("id", "SUCCESS", "title", "成功"));
        mapList.add(Map.of("id", "FAIL", "title", "失败"));
        mapList.add(Map.of("id", "CLOSE", "title", "关闭"));
        mapList.add(Map.of("id", "DELAY", "title", "待支付"));
        return YueResult.<List<Map<String, String>>>builder().data(mapList).build();
    }

}
