package cn.xisoil.curd.model.controller;

import cn.xisoil.common.to.ListStringRequest;
import cn.xisoil.common.to.SearchPageRequest;
import cn.xisoil.common.result.YueResult;
import cn.xisoil.curd.model.data.YueModelClassData;
import cn.xisoil.curd.model.data.YueModelColumns;
import cn.xisoil.curd.model.enums.YueClassType;
import cn.xisoil.curd.model.service.list.CurdDaoServiceImpl;
import cn.xisoil.curd.model.service.yueModel.YueModelService;
import cn.xisoil.curd.dao.YueRepository;
import cn.xisoil.log.enums.LOGTYPE;
import cn.xisoil.log.interfaces.CurdSystemLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

import jakarta.annotation.PostConstruct;
import jakarta.validation.Valid;
import java.lang.reflect.ParameterizedType;
import java.util.List;


public abstract class ModelCurdControllerMapping<T,R extends YueRepository<T,String>> extends CurdDaoServiceImpl<T,R> {

    @Autowired
    private YueModelService yueModelService;

    @PostConstruct
    public void  init(){
        Class<T> clazz = (Class<T>)((ParameterizedType)getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        super.setClass(clazz);
    }

    @GetMapping("/columns")
    public YueResult<YueModelClassData> getFieldsDec() {
        YueModelClassData yueModelClass=yueModelService.getYueClass(super.getTClass());
        List<YueModelColumns>yueModelColumnsList=yueModelService.getYueColumns(super.getTClass());
        yueModelClass.setColumns(yueModelColumnsList);
        yueModelClass.setType(YueClassType.LIST);
        return YueResult.<YueModelClassData>builder().data(yueModelClass).success().message("获取成功").build();
    }


    @PostMapping("/page")
    @CurdSystemLog(type = LOGTYPE.PAGE)
    public YueResult<Page<T>> page(@Valid @RequestBody SearchPageRequest searchPageRequest,BindingResult result) {
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<Page<T>>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.page(searchPageRequest);
    }

    @GetMapping("/list")
    @CurdSystemLog(type = LOGTYPE.LIST)
    public YueResult<List<T>> list() {
        return super.list();
    }

    @GetMapping("/search")
    @CurdSystemLog(type = LOGTYPE.LIST)
    public YueResult<List<T>> search(@RequestParam(value = "keyword",required = false,defaultValue = "")String keyword) {
        return super.search(keyword);
    }

    @PostMapping("/delete")
    @CurdSystemLog(type = LOGTYPE.DELETE)
    protected YueResult<String> delete(@Valid @RequestBody ListStringRequest stringRequest, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return  super.delete(stringRequest);
    }

    @PutMapping("")
    @CurdSystemLog(type = LOGTYPE.EDIT)
    public YueResult<String>edit(@Valid @RequestBody T request,BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.edit(request);
    }

    @PostMapping("")
    @CurdSystemLog(type = LOGTYPE.ADD)
    protected  YueResult<String>add(@Valid @RequestBody T request,BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return YueResult.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.add(request);
    }

    @GetMapping("/{id}")
    @CurdSystemLog(type = LOGTYPE.GET)
    public YueResult<T>get(@PathVariable String id){
        return super.get(id);
    }

}
