package cn.xisoil.auth.data.permission;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import cn.xisoil.curd.model.enums.YueColumnsType;
import cn.xisoil.curd.model.interfaces.CurdModel;
import cn.xisoil.curd.model.interfaces.CurdModelObject;
import lombok.Data;
import org.hibernate.annotations.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import jakarta.persistence.*;
import jakarta.persistence.Entity;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@Data
@Entity(name = "Permission")
@Table(name = "permission")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(name = "权限管理")
@FilterDef(name = "permissionChildren", parameters = {@ParamDef(name="ids",type=String.class)})
public class Permission {

    public Permission(){

    }
    public Permission(String title){
        this.title=title;
        this.name=title;
    }

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "所属父级",show = false,search = true,url = "/permission/list",type = YueColumnsType.LIST)
    private String parentId;

    @OneToMany(fetch = FetchType.EAGER)
    @JoinColumn(name = "parentId")
    @JsonIgnoreProperties("children")
    @Fetch(FetchMode.JOIN)
    @Filter(name = "permissionChildren", condition = " id in (:ids)   ")
    @OrderBy("comparable asc ")
    private Set<Permission> children=new HashSet<>();

    @CurdModel(value = "权限名称")
    private String name;

    private Date createTime;

    @CurdModel(value = "排序",comparable = true,type = YueColumnsType.NUMBER)
    private Integer comparable;

    private String title;

    public String getTitle() {
        return name;
    }

    @CurdModel(value = "权限地址")
    private String path;

    @CurdModel(value = "权限图标",url = "/ico/list",type = YueColumnsType.LIST)
    private String ico;

}
