package cn.xisoil.wallet.service.impl;

import com.alibaba.fastjson.JSONObject;
import cn.xisoil.auth.dao.user.UserRepository;
import cn.xisoil.auth.data.user.YueLoginUser;
import cn.xisoil.auth.config.token.JwtUtils;
import cn.xisoil.common.exception.NormalException;
import cn.xisoil.common.exception.ResponseException;
import cn.xisoil.common.result.YueResult;
import cn.xisoil.socket.ClientCache;
import cn.xisoil.system.model.data.YueBasicData;
import cn.xisoil.system.model.service.YueBasicDataService;
import cn.xisoil.vo.CallBackObj;
import cn.xisoil.vo.YuePayInfo;
import cn.xisoil.wallet.dao.YueOrderRepository;
import cn.xisoil.wallet.dao.YuePayMallRepository;
import cn.xisoil.wallet.data.OrderEnum;
import cn.xisoil.wallet.data.YueOrder;
import cn.xisoil.wallet.data.YuePayMall;
import cn.xisoil.wallet.service.YuePayService;
import cn.xisoil.wechat.WechatPayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Service
public class YuePayServiceImpl implements YuePayService {

    @Autowired
    private WechatPayUtils wechatPayUtils;
    @Autowired
    private YueOrderRepository yueOrderRepository;
    @Autowired
    private YueBasicDataService yueBasicDataService;
    @Autowired
    private YuePayMallRepository yuePayMallRepository;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private ClientCache clientCache;
    @Autowired
    private UserRepository userRepository;

    @Override
    public YueResult<String> pay(String id) {
        YueLoginUser yueLoginUser = jwtUtils.getLoginUser();
        YueBasicData yueBasicData = yueBasicDataService.get().getData();

        YuePayMall yuePayMall=yuePayMallRepository.findById(id).orElseThrow(()->new ResponseException("支付异常"));

        YueOrder yueOrder = new YueOrder();
        yueOrder.setOrderEnum(OrderEnum.DELAY);
        yueOrder.setPrice(yuePayMall.getPrice());
        yueOrder.setPayPrice(yuePayMall.getPayPrice());
        yueOrder.setUserId(yueLoginUser.getId());
        yueOrder.setRemark(yueLoginUser.getNickname() + "余额充值" + yuePayMall.getPrice().toString());
        yueOrder = yueOrderRepository.save(yueOrder);


        String baseUrl=wechatPayUtils.writeQrToString(YuePayInfo.builder()
                .notify_url(yueBasicData.getWxNotifyUrl())
                .orderNum(yueOrder.getId())
                .description(yueLoginUser.getNickname() + "余额充值" + yuePayMall.getPrice().toString())
                .total(yuePayMall.getPayPrice().multiply(BigDecimal.valueOf(100)).intValue())
                .build());

        yueOrder.setImage(baseUrl);
        yueOrderRepository.save(yueOrder);

        return YueResult.<String>builder().data(baseUrl).build();
    }


    @Override
    public void setCallBackObj(CallBackObj callBackObj) {
        JSONObject jsonObject = JSONObject.parseObject(wechatPayUtils.callBackContent(callBackObj));
        String out_trade_no = jsonObject.getString("out_trade_no");
        YueOrder yueOrder=yueOrderRepository.findById(out_trade_no).orElseThrow(()->new NormalException("数据不存在"));
        yueOrder.setOrderEnum(OrderEnum.SUCCESS);
        yueOrderRepository.save(yueOrder);

        YueLoginUser yueLoginUser=userRepository.findById(yueOrder.getUserId()).get();
        yueLoginUser.setPrice(yueLoginUser.getPrice().add(yueOrder.getPrice()));
        userRepository.save(yueLoginUser);
        try{
            clientCache.getUserClient(yueOrder.getUserId()).forEach((k,v)->{
                v.sendEvent("orderStatus",true);
            });
        }
        catch (Exception ignored){

        }

    }

    @Override
    public void setCallBackObj() {
        clientCache.getUserClient("1").forEach((k,v)->{
            v.sendEvent("orderStatus",true);
        });
    }
}
