package cn.xisoil.wallet.data;

import cn.xisoil.curd.model.enums.YueColumnsType;
import cn.xisoil.curd.model.interfaces.CurdModel;
import cn.xisoil.curd.model.interfaces.CurdModelObject;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import jakarta.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

@Data
@Entity(name = "YueOrder")
@Table(name = "yue_order")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(name = "订单管理", edit = false, add = false)
public class YueOrder {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    @CurdModel(value = "订单编号",editor = false,search = true)
    private String id;

    private String userId;

    @CurdModel(value = "入账金额",comparable = true)
    private BigDecimal price;

    @CurdModel(value = "支付金额",comparable = true)
    private BigDecimal payPrice;

    @CreatedDate
    @CurdModel(value = "添加时间",type = YueColumnsType.TIME,comparable = true)
    private Date createTime;

    @CurdModel(value = "付款二维码",type = YueColumnsType.IMAGE,editor = false)
    private String image;

    @CurdModel(value = "订单描述",type = YueColumnsType.TEXTAREA)
    private String remark;

    @CurdModel(value = "订单状态",type = YueColumnsType.LIST,url = "/order/type/list")
    @Enumerated(EnumType.STRING)
    private OrderEnum orderEnum;

}
