package cn.xisoil.file.service.strategy.impl;


import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import cn.xisoil.common.exception.NormalException;
import cn.xisoil.common.result.ResultFile;
import cn.xisoil.common.result.YueResult;
import cn.xisoil.common.to.ListStringRequest;
import cn.xisoil.file.dao.YueFileConfigRepository;
import cn.xisoil.file.data.UPLOADTYPE;
import cn.xisoil.file.data.YueFile;
import cn.xisoil.file.data.YueFileConfig;
import cn.xisoil.file.service.strategy.YueFileStrategy;
import cn.xisoil.file.service.manage.YueFileManageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

@Service(value = "ALYOSS")
public class YueFileStrategyAlyoss implements YueFileStrategy {

    @Autowired
    private YueFileManageService yueFileManageService;
    @Autowired
    private YueFileConfigRepository yueFileConfigRepository;


    @Override
    public ResultFile<String> upload(HttpServletRequest request) {
        YueFileConfig yueFileConfig=yueFileConfigRepository.findTopByIdNotNull().orElse(new YueFileConfig());

        String endpoint = yueFileConfig.getEndpoint();
        String accessKeyId = yueFileConfig.getAccessKeyId();
        String accessKeySecret = yueFileConfig.getAccessKeySecret();
        String bucketName = yueFileConfig.getBucketName();
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
        try {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
            MultipartFile multipartFile=multipartRequest.getFile("file");
            String fileName= multipartFile.getOriginalFilename();

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateNowStr = sdf.format(new Date());
            String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
            String objectName=dateNowStr+"-"+String.valueOf((int)(Math.random() * 1000000))+"."+fileExt;//随机文件名

            InputStream inputStream =multipartFile.getInputStream();
            // 创建PutObject请求。
            ossClient.putObject(bucketName, objectName, inputStream);
            ossClient.shutdown();

            String url="https://"+bucketName+".oss-cn-hangzhou.aliyuncs.com/"+objectName;
            YueFile yueFile=new YueFile();
            yueFile.setFilename(fileName);
            yueFile.setObjectName(objectName);
            yueFile.setUploadtype(UPLOADTYPE.ALYOSS);
            yueFile.setUrl(url);
            yueFileManageService.save(yueFile);
            return ResultFile.<String>builder()
                    .data(url)
                    .param(request.getHeader("key"))
                    .success().build();
        } catch (OSSException oe) {
        } catch (ClientException ce) {
            System.out.println("Error Message:" + ce.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
        }
        throw new NormalException("未知错误");
    }

    @Override
    public YueResult<String> delete(YueFile file) {
        YueFileConfig yueFileConfig=yueFileConfigRepository.findTopByIdNotNull().orElse(new YueFileConfig());
        String endpoint = yueFileConfig.getEndpoint();
        String accessKeyId = yueFileConfig.getAccessKeyId();
        String accessKeySecret = yueFileConfig.getAccessKeySecret();
        String bucketName = yueFileConfig.getBucketName();

        // 填写文件完整路径。文件完整路径中不能包含Bucket名称。
        String objectName = file.getObjectName();

        // 创建OSSClient实例。
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

        try {
            // 删除文件或目录。如果要删除目录，目录必须为空。
            ossClient.deleteObject(bucketName, objectName);
        } catch (OSSException oe) {
        } catch (ClientException ce) {
        } finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return YueResult.<String>builder().success().message("删除成功").build();
    }
}
