package cn.xisoil.curd.model.service.yueModel.impl;

import cn.xisoil.curd.model.data.YueModelClassData;
import cn.xisoil.curd.model.data.YueModelColumns;
import cn.xisoil.curd.model.enums.YueColumnsType;
import cn.xisoil.curd.model.interfaces.CurdModel;
import cn.xisoil.curd.model.interfaces.CurdModelObject;
import cn.xisoil.curd.model.service.yueModel.YueModelService;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import static cn.xisoil.curd.model.enums.YueColumnsType.*;


@Service
public class YueModelServiceImpl implements YueModelService {

    private static final List<YueColumnsType> KEYWORD_SEARCH = Arrays.asList(STRING, NUMBER, TEXTAREA);
    private static final List<YueColumnsType> LIST_SEARCH = Arrays.asList(LIST, CHECKBOX, RADIO, LISTMULTISELECT);


    @Override
    public List<YueModelColumns> getYueColumns(Class<?> clazz) {
        List<Field[]> list = new LinkedList<>();
        List<YueModelColumns> yueModelColumns = new ArrayList<>();
        list.add(clazz.getSuperclass().getDeclaredFields());
        list.add(clazz.getDeclaredFields());
        list.forEach(fields -> {
            for (Field field : fields) {
                boolean annotationPresent = field.isAnnotationPresent(CurdModel.class);
                if (annotationPresent) {
                    CurdModel curdModel = field.getAnnotation(CurdModel.class);
                    yueModelColumns.add(YueModelColumns.builder()
                            .column(field.getName())
                            .name(curdModel.value())
                            .type(curdModel.type())
                            .edit(curdModel.editor())
                            .search(curdModel.search())
                            .show(curdModel.show())
                            .url(curdModel.url())
                            .comparable(curdModel.comparable())
                            .required(curdModel.required())
                            .placeholder(curdModel.placeholder())
                            .build());
                }
            }
        });
        return yueModelColumns;
    }

    @Override
    public YueModelClassData getYueClass(Class<?> clazz) {
        CurdModelObject modelClass = clazz.getAnnotation(CurdModelObject.class);
        YueModelClassData yueModelClassData = new YueModelClassData();
        if (modelClass != null) {
            yueModelClassData.setAdd(modelClass.add());
            yueModelClassData.setName(modelClass.name());
            yueModelClassData.setEdit(modelClass.edit());
            yueModelClassData.setDelete(modelClass.delete());
        }
        return yueModelClassData;
    }

    @Override
    public List<String> getSearchColumn(Class<?> clazz) {
        List<Field[]> list = new LinkedList<>();
        List<String> columns = new ArrayList<>();
        list.add(clazz.getSuperclass().getDeclaredFields());
        list.add(clazz.getDeclaredFields());
        list.forEach(fields -> {
            for (Field field : fields) {
                boolean annotationPresent = field.isAnnotationPresent(CurdModel.class);
                CurdModel curdModel = field.getAnnotation(CurdModel.class);
                if (annotationPresent &&  curdModel.search() && KEYWORD_SEARCH.contains(curdModel.type())) {
                    columns.add(field.getName());
                }
            }
        });
        return columns;
    }

    @Override
    public List<YueModelColumns> getListSearchColumn(Class<?> clazz) {
        List<Field[]> list = new LinkedList<>();
        List<YueModelColumns> yueModelColumns = new ArrayList<>();
        list.add(clazz.getSuperclass().getDeclaredFields());
        list.add(clazz.getDeclaredFields());
        list.forEach(fields -> {
            for (Field field : fields) {
                boolean annotationPresent = field.isAnnotationPresent(CurdModel.class);
                CurdModel curdModel = field.getAnnotation(CurdModel.class);
                if (annotationPresent &&  curdModel.search() &&  LIST_SEARCH.contains(curdModel.type())) {
                    yueModelColumns.add(YueModelColumns.builder()
                            .column(field.getName())
                            .type(curdModel.type())
                            .build());
                }
            }
        });
        return yueModelColumns;
    }

    @Override
    public String getName(Class<?> clazz) {
//        CurdModelObject modelClass=clazz.getAnnotation(CurdModelObject.class);
        CurdModelObject modelClass = AnnotationUtils.getAnnotation(clazz, CurdModelObject.class);
        if (modelClass != null) {
            return modelClass.name();
        } else {
            return "";
        }
    }
}
