package cn.xisoil.curd.model.service.single;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import cn.xisoil.common.exception.NormalException;
import cn.xisoil.common.result.YueResult;
import cn.xisoil.common.to.ListStringRequest;
import cn.xisoil.common.to.SearchPageRequest;
import cn.xisoil.curd.dao.YueRepository;
import cn.xisoil.curd.model.data.YueModelColumns;
import cn.xisoil.curd.model.service.yueModel.YueModelService;
import cn.xisoil.curd.model.utils.YueContextUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

import jakarta.persistence.criteria.Predicate;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;

public class SingleDaoServiceImpl<T,R extends YueRepository<T,String>> {

    @Autowired
    private R repository;

    private Class<T> tClass;

    @Autowired
    private YueContextUtils yueContextUtils;

    @Autowired
    private YueModelService yueModelService;

    public void setClass(Class<T> tClass) {
        this.tClass=tClass;
    }

    public Class<T> getTClass() {
        return this.tClass;
    }

    public YueResult<String> edit(T request) {
        T t=repository.findTopByIdNotNull().orElse(newObj());
        BeanUtils.copyProperties(request,t);
        repository.save(t);
        return YueResult.<String>builder().success().message("修改成功").build();
    }

    public YueResult<List<T>> list(){
        List<T>list=repository.findAll();
        return YueResult.<List<T>>builder().success().message("获取成功").data(list).build();
    }

    public YueResult<T> get() {
        T t=repository.findTopByIdNotNull().orElse(newObj());
        return YueResult.<T>builder().success().data(t).message("获取成功").build();
    }


    public T newObj(){
        T newObj;
        try {
            newObj = this.tClass.getDeclaredConstructor().newInstance();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newObj;
    }



}
