package cn.xisoil.webmaster.data;


import cn.xisoil.common.to.StringConverters;
import cn.xisoil.curd.model.enums.YueColumnsType;
import cn.xisoil.curd.model.interfaces.CurdModel;
import cn.xisoil.curd.model.interfaces.CurdModelObject;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import jakarta.persistence.*;
import jakarta.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

@Data
@Entity(name = "YueSeoConfig")
@Table(name = "yue_seo_config")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(name = "站长配置")
public class YueSeoConfig {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    private String domain;

    @CurdModel(value = "百度密钥",editor = false,comparable = true)
    private String baiduKey;

    @CurdModel(value = "自动提交")
    private Boolean autoCommit;

    @CurdModel(value = "cron表达式",type = YueColumnsType.STRING)
    private String cron;

    @CurdModel(value = "360账号",type = YueColumnsType.STRING)
    private String account360;

    @CurdModel(value = "360密码",type = YueColumnsType.STRING)
    private String password360;

    private String accountSogou;

    private String passwordSogou;

}
