package cn.xisoil.wallet.service.impl;

import cn.xisoil.auth.config.token.JwtUtils;
import cn.xisoil.common.result.YueResult;
import cn.xisoil.common.to.SearchPageRequest;
import cn.xisoil.wallet.dao.YueOrderRepository;
import cn.xisoil.wallet.data.YueOrder;
import cn.xisoil.wallet.service.YueOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import jakarta.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;


@Service
public class YueOrderServiceImpl implements YueOrderService {

    @Autowired
    private YueOrderRepository yueOrderRepository;
    @Autowired
    private JwtUtils jwtUtils;

    @Override
    public YueResult<Page<YueOrder>> page(SearchPageRequest searchPageRequest) {
        Pageable pageable = PageRequest.of(searchPageRequest.getPageNum(), searchPageRequest.getPageSize());
        Specification<YueOrder> sectionSpecification = ((root, criteriaQuery, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            //字符类型搜索
            predicates.add(
                    criteriaBuilder.or(
                            criteriaBuilder.like(root.get("remark"), "%" + searchPageRequest.getKeyword() + "%"),
                            criteriaBuilder.like(root.get("id"), "%" + searchPageRequest.getKeyword() + "%"))
            );
            //排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("createTime")));
            predicates.add(criteriaBuilder.equal(root.get("userId"), jwtUtils.getLoginUser().getId()));
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        });
        Page<YueOrder> page = yueOrderRepository.findAll(sectionSpecification, pageable);
        return YueResult.<Page<YueOrder>>builder().message("获取成功").success().data(page).build();
    }
}
