package cn.xisoil.file.controller;

import cn.xisoil.common.result.YueResult;
import cn.xisoil.curd.model.controller.SingleModelController;
import cn.xisoil.file.dao.YueFileConfigRepository;
import cn.xisoil.file.data.UPLOADTYPE;
import cn.xisoil.file.data.YueFile;
import cn.xisoil.file.data.YueFileConfig;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/manage/file/config")
public class YueFileConfigController extends SingleModelController<YueFileConfig, YueFileConfigRepository> {


    @GetMapping("/type")
    public YueResult<List<Map<String,String>>>type(){
        List<Map<String,String>>list=new ArrayList<>();
        list.add(Map.of("id", UPLOADTYPE.LOCAL.getType(),"title","本地存储"));
        list.add(Map.of("id", UPLOADTYPE.ALYOSS.getType(),"title","阿里云存储"));
        return YueResult.<List<Map<String, String>>>builder().success().data(list).build();
    }


}
