package cn.xisoil.curd.model.utils;


import com.alibaba.fastjson.JSONObject;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.*;
import cn.xisoil.curd.model.controller.ModelCurdControllerMapping;
import cn.xisoil.curd.model.enums.YueClassType;
import cn.xisoil.curd.model.interfaces.CurdModelObject;
import cn.xisoil.curd.model.interfaces.CurdTrusteeShipObject;
import cn.xisoil.properties.YueProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.processing.*;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import java.io.IOException;
import java.util.*;

@AutoService(Processor.class)
public class AutoControllerProcessor extends AbstractProcessor {



    private Elements elementTool;
    private Messager messager;
    private Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        elementTool = processingEnv.getElementUtils();
        messager = processingEnv.getMessager();
        filer = processingEnv.getFiler();
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        Set<String> set = new HashSet<>();
        set.add(CurdModelObject.class.getCanonicalName());
        return set;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {

        if (!annotations.isEmpty()) {
            //获取Bind注解类型的元素，这里是类类型TypeElement
            Set<? extends Element> bindElement = roundEnv.getElementsAnnotatedWith(CurdModelObject.class);
            try {
                generateCode(bindElement);
            } catch (IOException | ClassNotFoundException e) {
                messager.printMessage(Diagnostic.Kind.ERROR, e.toString());
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }


    /**
     * @param elements
     */
    private void generateCode(Set<? extends Element> elements) throws IOException, ClassNotFoundException {

        for (Element element : elements) {

            CurdTrusteeShipObject curdTrusteeShipObject = element.getAnnotation(CurdModelObject.class).trusteeship();

            //由于是在类上注解，那么获取TypeElement
            TypeElement typeElement = (TypeElement) element;
            //获取全限定类名
            String QualifiedName = typeElement.getQualifiedName().toString();
            //获取包路径
            PackageElement packageElement = elementTool.getPackageOf(typeElement);
            String packageName = packageElement.getQualifiedName().toString();
            //获取用于生成的类名
            String className = getClassName(typeElement, packageName);

            String lowerClassName=className.toLowerCase();

            if (curdTrusteeShipObject.auto()) {

                //持久层模块名
                String persistent = StringUtils.isNotBlank(curdTrusteeShipObject.persistent())?
                        curdTrusteeShipObject.persistent():"cn.xisoil.dao."+lowerClassName;

                //持久层类名
                String persistentClass =  StringUtils.isNotBlank(curdTrusteeShipObject.persistentClass())?
                        curdTrusteeShipObject.persistentClass():className+"Repository";

                //控制层模块名
                String controller = StringUtils.isNotBlank(curdTrusteeShipObject.controller())?
                        curdTrusteeShipObject.controller():"cn.xisoil.controller."+lowerClassName;

                //控制层类名
                String controllerClass = StringUtils.isNotBlank(curdTrusteeShipObject.controllerClass())?
                        curdTrusteeShipObject.controllerClass():className+"Controller";
                //控制层mapping
                String controllerMapping = StringUtils.isNotBlank(curdTrusteeShipObject.controllerMapping())?
                        curdTrusteeShipObject.controllerMapping():"/manage/"+lowerClassName;

                //单页or列表页
                YueClassType yueClassType=curdTrusteeShipObject.type();

//                //生成方法
//                MethodSpec methodBuilder = MethodSpec
//                        .methodBuilder("getTclass")
//                        .addModifiers(Modifier.PUBLIC)
//                        .returns(Class.class)
//                        .addAnnotation(Override.class)
//                        .addStatement("return $L", packageName + "." + className + ".class").build();
//                List<MethodSpec> specList = new LinkedList<>();

                ClassName yueRepository = ClassName.get("cn.xisoil.curd.dao", "YueRepository");
                //生成的类
                TypeSpec persistentType = TypeSpec
                        .interfaceBuilder(persistentClass)
                        .addModifiers(Modifier.PUBLIC)
                        .addSuperinterface(ParameterizedTypeName.get(yueRepository,
                                ClassName.get(packageName, className),
                                ClassName.get("java.lang", "String")))
                        .build();
                JavaFile.builder(persistent, persistentType)
                        .build().writeTo(filer);


                AnnotationSpec requestMapping = AnnotationSpec
                        .builder(RequestMapping.class)
                        .addMember("value", "$S", controllerMapping).build();

                AnnotationSpec restController = AnnotationSpec
                        .builder(RestController.class)
                        .addMember("value", "$S", controllerClass).build();

                ClassName ModelCurdControllerMapping = ClassName.get("cn.xisoil.curd.model.controller",
                        yueClassType.equals(YueClassType.LIST)?"ModelCurdControllerMapping":"SingleModelController");

                //生成的类
                TypeSpec type = TypeSpec
                        .classBuilder(controllerClass )
                        .addModifiers(Modifier.PUBLIC)
                        .superclass(ParameterizedTypeName.get(ModelCurdControllerMapping,
                                ClassName.get(packageName, className),
                                ClassName.get(persistent,persistentClass)))
                        .addAnnotation(requestMapping)
                        .addAnnotation(restController)
                        .build();
                //创建javaFile文件对象
                JavaFile.builder(controller, type)
                        .build().writeTo(filer);

            }


//            try{
//                for (String oneToOne : bindAnnotation.foreignKey()) {
//                    if (!oneToOne.equals("")){
//                        AnnotationSpec requestMapping = AnnotationSpec
//                                .builder(GetMapping.class)
//                                .addMember("value","$S","/"+oneToOne.toLowerCase()+"/{"+oneToOne.toLowerCase()+"Id}").build();
//                        specList.add(MethodSpec
//                                .methodBuilder("get"+oneToOne)
//                                .addModifiers(Modifier.PUBLIC)
//                                .addParameter(ParameterSpec
//                                        .builder(String.class,oneToOne.toLowerCase()+"Id")
//                                        .addAnnotation(PathVariable.class)
//                                        .build())
//                                .returns(Result.class)
//                                .addAnnotation(requestMapping)
//                                .addStatement("return super.getByForeignkey($L,$S)",oneToOne.toLowerCase()+"Id",oneToOne).build());
//                    }
//                }
//            }
//            catch (Exception a){
//                messager.printMessage(Diagnostic.Kind.WARNING,a.toString());
//            }



        }
    }


    private static String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen)
                .replace('.', '$');
    }


}
