package cn.xisoil.analysis.controller;


import cn.xisoil.analysis.dto.AnalysisRequest;
import cn.xisoil.analysis.dto.StatisticalVo;
import cn.xisoil.analysis.sercvice.YueAnalysisService;
import cn.xisoil.common.result.YueResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping("/manage/analysis")
public class AnalysisController {

    @Autowired
    private YueAnalysisService yueAnalysisService;

    @GetMapping("/equipment")
    public YueResult<AnalysisRequest>equipment(){
        return yueAnalysisService.equipment();
    }

    @GetMapping("/section")
    public YueResult<AnalysisRequest>getSectionBar(){
        return yueAnalysisService.getSectionBar();
    }

    @GetMapping("/browser")
    public YueResult<AnalysisRequest>getBrowser(){
        return yueAnalysisService.getBrowser();
    }

    @GetMapping("/date")
    public YueResult<StatisticalVo>getDate(){
        return yueAnalysisService.getPVAndUV();
    }

}
