/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.wechat;

import cn.xisoil.utils.HttpRequestIpUtil;
import cn.xisoil.vo.CallBackObj;
import cn.xisoil.vo.YuePayInfo;
import cn.xisoil.wechat.AesUtil;
import cn.xisoil.wechat.WechatPayConfig;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class WechatPayUtils {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WechatPayConfig wechatPayConfig;
    @Autowired
    private HttpRequestIpUtil httpRequestIpUtil;
    int width = 200;
    int height = 200;
    String format = "png";

    public void writeQrToStream(YuePayInfo yuePayInfo) throws Exception {
        HashMap<EncodeHintType, Object> config = new HashMap<EncodeHintType, Object>();
        config.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        config.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        config.put(EncodeHintType.MARGIN, 0);
        HttpPost httpPost = new HttpPost("https://api.mch.weixin.qq.com/v3/pay/transactions/native");
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        ServletOutputStream out = response.getOutputStream();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode rootNode = objectMapper.createObjectNode();
        rootNode.put("mchid", this.wechatPayConfig.getMchId()).put("appid", this.wechatPayConfig.getAppId()).put("description", yuePayInfo.getDescription()).put("notify_url", yuePayInfo.getNotify_url()).put("out_trade_no", yuePayInfo.getOrderNum());
        rootNode.putObject("amount").put("total", yuePayInfo.getTotal()).put("currency", "CNY");
        objectMapper.writeValue((OutputStream)bos, (Object)rootNode);
        httpPost.setEntity((HttpEntity)new StringEntity(bos.toString(StandardCharsets.UTF_8), "UTF-8"));
        CloseableHttpResponse closeableHttpResponse = this.wechatPayConfig.getHttpClient().execute((HttpUriRequest)httpPost);
        String bodyAsString = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
        JSONObject jsonObject = JSONObject.parseObject((String)bodyAsString);
        if (jsonObject.getString("code") != null) {
            this.logger.error("\u5fae\u4fe1\u652f\u4ed8==>{}", (Object)jsonObject.getString("message"));
        }
        BitMatrix bitMatrix = new MultiFormatWriter().encode(jsonObject.getString("code_url"), BarcodeFormat.QR_CODE, this.width, this.height, config);
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)this.format, (OutputStream)out);
    }

    public String wapPay(YuePayInfo yuePayInfo) {
        HttpPost httpPost = new HttpPost("https://api.mch.weixin.qq.com/v3/pay/transactions/h5");
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode rootNode = objectMapper.createObjectNode();
        rootNode.put("mchid", this.wechatPayConfig.getMchId()).put("appid", this.wechatPayConfig.getAppId()).put("description", yuePayInfo.getDescription()).put("notify_url", yuePayInfo.getNotify_url()).put("out_trade_no", yuePayInfo.getOrderNum());
        rootNode.putObject("amount").put("total", yuePayInfo.getTotal()).put("currency", "CNY");
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        rootNode.putObject("scene_info").put("payer_client_ip", this.httpRequestIpUtil.getIpAddress(request)).putObject("h5_info").put("type", "Wap");
        objectMapper.writeValue((OutputStream)bos, (Object)rootNode);
        httpPost.setEntity((HttpEntity)new StringEntity(bos.toString(StandardCharsets.UTF_8), "UTF-8"));
        CloseableHttpResponse closeableHttpResponse = this.wechatPayConfig.getHttpClient().execute((HttpUriRequest)httpPost);
        String bodyAsString = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
        JSONObject jsonObject = JSONObject.parseObject((String)bodyAsString);
        if (jsonObject.getString("code") != null) {
            this.logger.error("\u5fae\u4fe1\u652f\u4ed8==>{}", (Object)jsonObject.getString("message"));
        }
        return jsonObject.getString("h5_url");
    }

    public String writeQrToString(YuePayInfo yuePayInfo) {
        HashMap<EncodeHintType, Object> config = new HashMap<EncodeHintType, Object>();
        config.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        config.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        config.put(EncodeHintType.MARGIN, 0);
        HttpPost httpPost = new HttpPost("https://api.mch.weixin.qq.com/v3/pay/transactions/native");
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode rootNode = objectMapper.createObjectNode();
        rootNode.put("mchid", this.wechatPayConfig.getMchId()).put("appid", this.wechatPayConfig.getAppId()).put("description", yuePayInfo.getDescription()).put("notify_url", yuePayInfo.getNotify_url()).put("out_trade_no", yuePayInfo.getOrderNum());
        rootNode.putObject("amount").put("total", yuePayInfo.getTotal()).put("currency", "CNY");
        objectMapper.writeValue((OutputStream)bos, (Object)rootNode);
        httpPost.setEntity((HttpEntity)new StringEntity(bos.toString(StandardCharsets.UTF_8), "UTF-8"));
        CloseableHttpResponse closeableHttpResponse = this.wechatPayConfig.getHttpClient().execute((HttpUriRequest)httpPost);
        String bodyAsString = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
        JSONObject jsonObject = JSONObject.parseObject((String)bodyAsString);
        if (jsonObject.getString("code") != null) {
            this.logger.error("\u5fae\u4fe1\u652f\u4ed8==>{}", (Object)jsonObject.getString("message"));
        }
        BitMatrix bitMatrix = new MultiFormatWriter().encode(jsonObject.getString("code_url"), BarcodeFormat.QR_CODE, this.width, this.height, config);
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        return WechatPayUtils.BufferedImageToBase64(bufferedImage);
    }

    public String callBackContent(CallBackObj callBackObj) {
        AesUtil aesUtil = new AesUtil(this.wechatPayConfig.getAppV3Secret().getBytes());
        String s = aesUtil.decryptToString(callBackObj.getResource().getAssociated_data().getBytes(), callBackObj.getResource().getNonce().getBytes(), callBackObj.getResource().getCiphertext());
        return s;
    }

    private static String BufferedImageToBase64(BufferedImage bufferedImage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] bytes = baos.toByteArray();
        Base64 encoder = new Base64();
        String png_base64 = encoder.encodeToString(bytes).trim();
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        System.out.println("\u503c\u4e3a\uff1adata:image/jpg;base64," + png_base64);
        return "data:image/jpg;base64," + png_base64;
    }

    private static BufferedImage base64ToBufferedImage(String base64) {
        Base64 decoder = new Base64();
        try {
            byte[] bytes1 = decoder.decode(base64);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes1);
            return ImageIO.read(bais);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

