/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.wechat;

import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.Signer;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.cert.CertificatesManager;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ConfigurationProperties(prefix="yue.pay.wechat", ignoreUnknownFields=true, ignoreInvalidFields=true)
public class WechatPayConfig
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String appId;
    private String appSecret;
    private String appV3Secret;
    private String mchId;
    private String privateKeyPath = "";
    private String serialNo;
    private PrivateKey privateKey;
    private CloseableHttpClient httpClient;

    public void afterPropertiesSet() throws Exception {
        if (this.privateKeyPath.equals("")) {
            this.logger.warn("\u5fae\u4fe1\u652f\u4ed8===>\u8bc1\u4e66\u5730\u5740\u9519\u8bef{\u8bf7\u586b\u5199\u6b63\u786e\u7684apiclient_key.pem\u5730\u5740}");
        } else {
            this.privateKey = PemUtil.loadPrivateKey((InputStream)new ClassPathResource(this.privateKeyPath).getInputStream());
            this.initWechatHttp();
            this.logger.info("\u5fae\u4fe1\u652f\u4ed8\u5df2\u51c6\u5907");
        }
    }

    public void initWechatHttp() throws Exception {
        CertificatesManager certificatesManager = CertificatesManager.getInstance();
        certificatesManager.putMerchant(this.mchId, (Credentials)new WechatPay2Credentials(this.mchId, (Signer)new PrivateKeySigner(this.serialNo, this.privateKey)), this.appV3Secret.getBytes(StandardCharsets.UTF_8));
        Verifier verifier = certificatesManager.getVerifier(this.mchId);
        WechatPayHttpClientBuilder builder = WechatPayHttpClientBuilder.create().withMerchant(this.mchId, this.serialNo, this.privateKey).withValidator((Validator)new WechatPay2Validator(verifier));
        this.httpClient = builder.build();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getAppV3Secret() {
        return this.appV3Secret;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setAppV3Secret(String appV3Secret) {
        this.appV3Secret = appV3Secret;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WechatPayConfig)) {
            return false;
        }
        WechatPayConfig other = (WechatPayConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$appSecret = this.getAppSecret();
        String other$appSecret = other.getAppSecret();
        if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
            return false;
        }
        String this$appV3Secret = this.getAppV3Secret();
        String other$appV3Secret = other.getAppV3Secret();
        if (this$appV3Secret == null ? other$appV3Secret != null : !this$appV3Secret.equals(other$appV3Secret)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$privateKeyPath = this.getPrivateKeyPath();
        String other$privateKeyPath = other.getPrivateKeyPath();
        if (this$privateKeyPath == null ? other$privateKeyPath != null : !this$privateKeyPath.equals(other$privateKeyPath)) {
            return false;
        }
        String this$serialNo = this.getSerialNo();
        String other$serialNo = other.getSerialNo();
        if (this$serialNo == null ? other$serialNo != null : !this$serialNo.equals(other$serialNo)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        CloseableHttpClient this$httpClient = this.getHttpClient();
        CloseableHttpClient other$httpClient = other.getHttpClient();
        return !(this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WechatPayConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $appSecret = this.getAppSecret();
        result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
        String $appV3Secret = this.getAppV3Secret();
        result = result * 59 + ($appV3Secret == null ? 43 : $appV3Secret.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $privateKeyPath = this.getPrivateKeyPath();
        result = result * 59 + ($privateKeyPath == null ? 43 : $privateKeyPath.hashCode());
        String $serialNo = this.getSerialNo();
        result = result * 59 + ($serialNo == null ? 43 : $serialNo.hashCode());
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        CloseableHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        return result;
    }

    public String toString() {
        return "WechatPayConfig(logger=" + this.getLogger() + ", appId=" + this.getAppId() + ", appSecret=" + this.getAppSecret() + ", appV3Secret=" + this.getAppV3Secret() + ", mchId=" + this.getMchId() + ", privateKeyPath=" + this.getPrivateKeyPath() + ", serialNo=" + this.getSerialNo() + ", privateKey=" + this.getPrivateKey() + ", httpClient=" + this.getHttpClient() + ")";
    }
}

