/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.socket;

import cn.xisoil.socket.SocketIOHandler;
import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.SocketConfig;
import com.corundumstudio.socketio.SocketIOServer;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@org.springframework.context.annotation.Configuration
@ConfigurationProperties(prefix="yue.socketio", ignoreUnknownFields=true, ignoreInvalidFields=true)
public class SocketIOConfig
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SocketIOHandler socketIOHandler;
    private String host = "localhost";
    private Integer port = 9092;
    private int bossCount = 1;
    private int workCount = 100;
    private boolean allowCustomRequests = true;
    private int upgradeTimeout = 1000000;
    private int pingTimeout = 6000000;
    private int pingInterval = 25000;

    public void afterPropertiesSet() throws Exception {
        SocketConfig socketConfig = new SocketConfig();
        socketConfig.setReuseAddress(true);
        socketConfig.setTcpNoDelay(true);
        socketConfig.setSoLinger(0);
        Configuration configuration = new Configuration();
        configuration.setSocketConfig(socketConfig);
        configuration.setHostname(this.host);
        configuration.setPort(this.port.intValue());
        configuration.setBossThreads(this.bossCount);
        configuration.setWorkerThreads(this.workCount);
        configuration.setAllowCustomRequests(this.allowCustomRequests);
        configuration.setUpgradeTimeout(this.upgradeTimeout);
        configuration.setPingTimeout(this.pingTimeout);
        configuration.setPingInterval(this.pingInterval);
        SocketIOServer socketIOServer = new SocketIOServer(configuration);
        socketIOServer.addListeners((Object)this.socketIOHandler);
        socketIOServer.start();
        this.logger.info("\u8fdb\u7a0b\u4fe1\u606f==>socketIO\u8fdb\u7a0b\u5df2\u542f\u52a8");
        this.logger.info("socketIO\u7aef\u53e3==>{}", (Object)this.port);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public SocketIOHandler getSocketIOHandler() {
        return this.socketIOHandler;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public int getBossCount() {
        return this.bossCount;
    }

    public int getWorkCount() {
        return this.workCount;
    }

    public boolean isAllowCustomRequests() {
        return this.allowCustomRequests;
    }

    public int getUpgradeTimeout() {
        return this.upgradeTimeout;
    }

    public int getPingTimeout() {
        return this.pingTimeout;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void setSocketIOHandler(SocketIOHandler socketIOHandler) {
        this.socketIOHandler = socketIOHandler;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setBossCount(int bossCount) {
        this.bossCount = bossCount;
    }

    public void setWorkCount(int workCount) {
        this.workCount = workCount;
    }

    public void setAllowCustomRequests(boolean allowCustomRequests) {
        this.allowCustomRequests = allowCustomRequests;
    }

    public void setUpgradeTimeout(int upgradeTimeout) {
        this.upgradeTimeout = upgradeTimeout;
    }

    public void setPingTimeout(int pingTimeout) {
        this.pingTimeout = pingTimeout;
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SocketIOConfig)) {
            return false;
        }
        SocketIOConfig other = (SocketIOConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBossCount() != other.getBossCount()) {
            return false;
        }
        if (this.getWorkCount() != other.getWorkCount()) {
            return false;
        }
        if (this.isAllowCustomRequests() != other.isAllowCustomRequests()) {
            return false;
        }
        if (this.getUpgradeTimeout() != other.getUpgradeTimeout()) {
            return false;
        }
        if (this.getPingTimeout() != other.getPingTimeout()) {
            return false;
        }
        if (this.getPingInterval() != other.getPingInterval()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        SocketIOHandler this$socketIOHandler = this.getSocketIOHandler();
        SocketIOHandler other$socketIOHandler = other.getSocketIOHandler();
        if (this$socketIOHandler == null ? other$socketIOHandler != null : !this$socketIOHandler.equals(other$socketIOHandler)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SocketIOConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBossCount();
        result = result * 59 + this.getWorkCount();
        result = result * 59 + (this.isAllowCustomRequests() ? 79 : 97);
        result = result * 59 + this.getUpgradeTimeout();
        result = result * 59 + this.getPingTimeout();
        result = result * 59 + this.getPingInterval();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        SocketIOHandler $socketIOHandler = this.getSocketIOHandler();
        result = result * 59 + ($socketIOHandler == null ? 43 : $socketIOHandler.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "SocketIOConfig(logger=" + this.getLogger() + ", socketIOHandler=" + this.getSocketIOHandler() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", bossCount=" + this.getBossCount() + ", workCount=" + this.getWorkCount() + ", allowCustomRequests=" + this.isAllowCustomRequests() + ", upgradeTimeout=" + this.getUpgradeTimeout() + ", pingTimeout=" + this.getPingTimeout() + ", pingInterval=" + this.getPingInterval() + ")";
    }
}

