/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.socket;

import com.corundumstudio.socketio.SocketIOClient;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class ClientCache {
    private static final Map<String, HashMap<UUID, SocketIOClient>> concurrentHashMap = new ConcurrentHashMap<String, HashMap<UUID, SocketIOClient>>();

    public void saveClient(String userId, UUID sessionId, SocketIOClient socketIOClient) {
        HashMap<UUID, Object> sessionIdClientCache = concurrentHashMap.get(userId);
        if (sessionIdClientCache == null) {
            sessionIdClientCache = new HashMap();
        }
        sessionIdClientCache.put(sessionId, socketIOClient);
        concurrentHashMap.put(userId, sessionIdClientCache);
    }

    public HashMap<UUID, SocketIOClient> getUserClient(String userId) {
        return concurrentHashMap.get(userId);
    }

    public void deleteSessionClientByUserId(String userId, UUID sessionId) {
        concurrentHashMap.get(userId).remove(sessionId);
    }

    public void deleteUserCacheByUserId(String userId) {
        concurrentHashMap.remove(userId);
    }
}

