package cn.xisoil.entity;

import cn.xisoil.common.to.StringConverters;
import cn.xisoil.curd.model.enums.ObjectColumnType;
import cn.xisoil.curd.model.enums.ObjectType;
import cn.xisoil.curd.model.interfaces.CurdModel;
import cn.xisoil.curd.model.interfaces.CurdModelObject;
import cn.xisoil.curd.model.interfaces.CurdTrusteeShipObject;
import cn.xisoil.curd.model.interfaces.PermissionTrusteeShipObject;
import jakarta.persistence.*;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import java.util.ArrayList;
import java.util.List;

@Data
@Entity(name = "TCY")
@Table(name = "TCY")
@CurdModelObject(trusteeship =
@CurdTrusteeShipObject(controllerMapping = "/tcy",type = ObjectType.SINGLE),
        permission = @PermissionTrusteeShipObject(key = "",parent = "测试栏目"),
        value = "TCY栏目",
        edit = true,
        add = true
)
public class TCY  {


    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid",strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;


    @CurdModel(value = "名称",search = true)
    private String name;


    @CurdModel(value = "搜索",type = ObjectColumnType.SEARCHLIST,url = "/people/search")
    private String pid;

    @CurdModel(value = "排序",type = ObjectColumnType.NUMBER,comparable = true)
    private Integer comparable;

    @CurdModel(value = "性别",type = ObjectColumnType.LIST,url = "/sex",search = true)
    private String sex;

    @CurdModel(value = "图片",type = ObjectColumnType.IMAGE)
    private String image;

    @CurdModel(value = "图片列表",type = ObjectColumnType.IMAGELIST)
    @Convert(converter = StringConverters.class)
    private List<String>images=new ArrayList<>();



    @OneToMany(cascade = CascadeType.ALL)
    @CurdModel(value = "表格",type = ObjectColumnType.TABLE,url = "/people/columns")
    private List<People> peopleSet=new ArrayList<>();


}
