package cn.xisoil.entity;


import cn.xisoil.common.to.StringConverters;
import cn.xisoil.curd.model.enums.ObjectColumnType;
import cn.xisoil.curd.model.enums.ObjectType;
import cn.xisoil.curd.model.interfaces.CurdModel;
import cn.xisoil.curd.model.interfaces.CurdModelObject;
import cn.xisoil.curd.model.interfaces.CurdTrusteeShipObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Table;
import jakarta.persistence.*;
import lombok.Data;
import org.hibernate.annotations.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.util.ArrayList;
import java.util.List;


@Data
@Entity(name = "people")
@Table(name = "people")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "用户信息",trusteeship = @CurdTrusteeShipObject(type = ObjectType.LIST))
@FilterDef(name = "permissionChildren", parameters = {@ParamDef(name="ids",type=String.class)})
public class People {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;


    @CurdModel(value = "name",search = true)
    private String name;

    @CurdModel(value = "title",search = true)
    private String title;

    @CurdModel(value = "图片",type = ObjectColumnType.IMAGE)
    private String image;

    @Convert(converter = StringConverters.class)
    @CurdModel(value = "图片列表",type = ObjectColumnType.IMAGELIST)
    private List<String> images = new ArrayList<>();

    @ManyToOne
    @JsonIgnore
    @JoinColumn(name = "tcy_id")
    private TCY tcy;


}
