package cn.xisoil.controller.tcy;

import cn.xisoil.common.result.YueResult;
import cn.xisoil.curd.model.controller.SingleModelController;
import cn.xisoil.dao.tcy.TCYRepository;
import cn.xisoil.entity.TCY;
import cn.xisoil.log.interfaces.Log;
import jakarta.validation.Valid;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping("/manage/tcy")
@RestController("TCYController")
public class TCYController extends SingleModelController<TCY, TCYRepository> {
  @Log("获取TCY栏目详情")
  @GetMapping("")
  public YueResult get() {
    return super.get();
  }

  @PutMapping("")
  @Log("修改TCY栏目")
  public YueResult edit(@Valid @RequestBody TCY request, BindingResult result) {
    return super.edit(request);
  }
}
