package cn.xisoil.controller.people;

import cn.xisoil.common.result.YueResult;
import cn.xisoil.common.to.ListStringRequest;
import cn.xisoil.common.to.SearchPageRequest;
import cn.xisoil.curd.model.controller.ModelCurdController;
import cn.xisoil.dao.people.PeopleRepository;
import cn.xisoil.entity.People;
import cn.xisoil.log.interfaces.Log;
import jakarta.validation.Valid;
import java.lang.String;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping("/manage/people")
@RestController("PeopleController")
public class PeopleController extends ModelCurdController<People, PeopleRepository> {
  @PostMapping("/delete")
  @Log("删除用户信息")
  public YueResult delete(@Valid @RequestBody ListStringRequest stringRequest,
      BindingResult result) {
    return super.delete(stringRequest,result);
  }

  @PostMapping("")
  @Log("增加用户信息")
  public YueResult add(@Valid @RequestBody People request, BindingResult result) {
    return super.add(request);
  }

  @PostMapping("/page")
  @Log("分页获取用户信息")
  public YueResult page(@Valid @RequestBody SearchPageRequest searchPageRequest,
      BindingResult result) {
    return super.page(searchPageRequest);
  }

  @PutMapping("")
  @Log("修改用户信息")
  public YueResult edit(@Valid @RequestBody People request, BindingResult result) {
    return super.edit(request);
  }

  @GetMapping("/{id}")
  @Log("获取用户信息详情")
  public YueResult get(@PathVariable String id) {
    return super.get(id);
  }
}
