/*
 * Decompiled with CFR 0.152.
 */
package cn.xinyue365.common.http;

import cn.xinyue365.common.exception.SDKException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.log4j.Logger;

public class HttpConnection {
    private static final Logger logger = Logger.getLogger(HttpConnection.class);
    private static final OkHttpClient clientSingleton = new OkHttpClient();
    private final OkHttpClient client;

    public HttpConnection(Integer connTimeout, Integer readTimeout, Integer writeTimeout) {
        this.client = clientSingleton.newBuilder().connectTimeout((long)connTimeout.intValue(), TimeUnit.SECONDS).readTimeout((long)readTimeout.intValue(), TimeUnit.SECONDS).writeTimeout((long)writeTimeout.intValue(), TimeUnit.SECONDS).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doRequest(Request request) throws IOException {
        int retries = 3;
        IOException lastException = null;
        int i = 0;
        while (i < retries) {
            try (Response response = this.client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("HTTP error: " + response.code());
                }
                String string = response.body().string();
                return string;
            }
            catch (IOException e) {
                lastException = e;
                logger.error((Object)("Request attempt " + (i + 1) + " failed: " + e.getMessage()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException throwable) {
                    // empty catch block
                }
                ++i;
            }
        }
        throw lastException;
    }

    public String getRequest(String url) throws SDKException, IOException {
        Request request = null;
        try {
            request = new Request.Builder().url(url).get().build();
        }
        catch (IllegalArgumentException e) {
            throw new SDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public String getRequest(String url, Headers headers) throws SDKException, IOException {
        Request request = null;
        try {
            request = new Request.Builder().url(url).headers(headers).get().build();
        }
        catch (IllegalArgumentException e) {
            throw new SDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public String postRequest(String url, String body) throws SDKException, IOException {
        MediaType contentType = MediaType.parse((String)"application/x-www-form-urlencoded");
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create((String)body, (MediaType)contentType)).build();
        }
        catch (IllegalArgumentException e) {
            throw new SDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public String postRequest(String url, String body, Headers headers) throws SDKException, IOException {
        Request request;
        MediaType contentType = MediaType.parse((String)headers.get("Content-Type"));
        try {
            request = new Request.Builder().url(url).post(RequestBody.create((String)body, (MediaType)contentType)).headers(headers).build();
        }
        catch (IllegalArgumentException e) {
            throw new SDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public String postRequest(String url, byte[] body, Headers headers) throws SDKException, IOException {
        MediaType contentType = MediaType.parse((String)headers.get("Content-Type"));
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create((byte[])body, (MediaType)contentType)).headers(headers).build();
        }
        catch (IllegalArgumentException e) {
            throw new SDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public String postRequest(String url, RequestBody body, Headers headers) throws SDKException, IOException {
        Request request;
        try {
            request = new Request.Builder().url(url).post(body).headers(headers).build();
        }
        catch (IllegalArgumentException e) {
            throw new SDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }
}

