/*
 * Decompiled with CFR 0.152.
 */
package cn.xinyue365.common;

import cn.xinyue365.common.AbstractRequest;
import cn.xinyue365.common.AbstractResponse;
import cn.xinyue365.common.Credential;
import cn.xinyue365.common.ResponseFactory;
import cn.xinyue365.common.Sign;
import cn.xinyue365.common.http.HttpConnection;
import cn.xinyue365.common.profile.HttpProfile;
import com.google.gson.Gson;
import java.io.IOException;
import java.time.Instant;
import okhttp3.Headers;

public abstract class AbstractClient {
    protected static final Gson gson = new Gson();
    protected final Credential credential;
    protected final String endpoint;
    private HttpConnection httpConnection;

    protected AbstractClient(Credential credential, String endpoint) {
        this.credential = credential;
        this.endpoint = endpoint;
    }

    public AbstractClient(Credential credential, HttpProfile httpProfile, String endpoint) {
        this.credential = credential;
        this.endpoint = endpoint;
        this.httpConnection = new HttpConnection(httpProfile.getConnTimeout(), httpProfile.getReadTimeout(), httpProfile.getWriteTimeout());
    }

    protected <T extends AbstractResponse<?>> T postCall(String action, AbstractRequest request, Class<T> responseClass) {
        try {
            String timestamp = String.valueOf(Instant.now().getEpochSecond());
            String payload = request.toJson();
            String stringToSign = timestamp + "\\n" + payload;
            String signature = Sign.sign(stringToSign, this.credential.getSecretKey());
            Headers.Builder headerBuilder = new Headers.Builder().add("Content-Type", "application/json").add("Authorization", signature).add("X-Timestamp", timestamp).add("X-Secret-Id", this.credential.getSecretId());
            String responseStr = this.httpConnection.postRequest(this.endpoint + action, payload, headerBuilder.build());
            return (T)((AbstractResponse)new Gson().fromJson(responseStr, responseClass));
        }
        catch (IOException e) {
            return ResponseFactory.failure(responseClass, e);
        }
    }
}

