package cn.ximcloud.homekit.core.starter.core.service.impl;

import cn.ximcloud.homekit.core.starter.auth.BaseOnDataBaseHomeKitAuthInfo;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;


@Slf4j
public class BaseOnDataBaseHomeKitService implements HomeKitService {

    private HomekitAuthInfo ximCloudHomeKitAuthInfo;

    /**
     * 获取HomeKit 配置
     *
     * @return MockAuthInfo
     */
    @SneakyThrows
    @Override
    public HomekitAuthInfo getAuthInfo() {
        return (this.ximCloudHomeKitAuthInfo = new BaseOnDataBaseHomeKitAuthInfo());
    }


    /**
     * 设备列表
     *
     * @return List<HomeKitAccessory>
     */
    @Override
    public List<HomekitAccessory> getAccessoryList() {
        return new ArrayList<>();
    }


}
