package cn.ximcloud.homekit.core.starter.core.condition;


import cn.ximcloud.homekit.core.starter.constants.DataSourceConstant;
import org.apache.logging.log4j.util.Strings;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;

import static cn.ximcloud.homekit.core.starter.config.HomeKitDataSourceConfig.DATA_SOURCE_CONFIG_PREFIX;
import static cn.ximcloud.homekit.core.starter.core.condition.BaseOnDatabaseHomeKitCondition.DATA_SOURCE_CONFIG_PATH;

public class SimpleDemoHomeKitCondition implements Condition {

    /**
     * Determine if the condition matches.
     *
     * @param context  the condition context
     * @param metadata the metadata of the {@link AnnotationMetadata class}
     *                 or {@link MethodMetadata method} being checked
     * @return {@code true} if the condition matches and the component can be registered,
     * or {@code false} to veto the annotated component's registration
     */
    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        DataSourceConstant type = environment.getProperty(DATA_SOURCE_CONFIG_PREFIX.concat(".type"), DataSourceConstant.class);
        return Strings.isBlank(environment.getProperty(DATA_SOURCE_CONFIG_PATH, String.class))
                && (type == null || DataSourceConstant.SIMPLE_DEMO.equals(type));
    }
}
