package cn.ximcloud.homekit.core.starter.core.condition;

import cn.ximcloud.homekit.core.starter.constants.DataSourceConstant;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.util.Strings;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;

import static cn.ximcloud.homekit.core.starter.config.HomeKitDataSourceConfig.DATA_SOURCE_CONFIG_PREFIX;

@Slf4j
public class BaseOnDatabaseHomeKitCondition implements Condition {

    public static final String DATA_SOURCE_CONFIG_PATH = "spring.datasource.url";

    /**
     * Determine if the condition matches.
     *
     * @param context  the condition context
     * @param metadata the metadata of the {@link AnnotationMetadata class}
     *                 or {@link MethodMetadata method} being checked
     * @return {@code true} if the condition matches and the component can be registered,
     * or {@code false} to veto the annotated component's registration
     */
    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        return !Strings.isBlank(environment.getProperty(DATA_SOURCE_CONFIG_PATH, String.class))
                && !DataSourceConstant.SIMPLE_DEMO.equals(environment.getProperty(DATA_SOURCE_CONFIG_PREFIX.concat(".type"), DataSourceConstant.class));
    }
}
