package cn.ximcloud.homekit.core.starter.core.bootstrap;

import cn.ximcloud.homekit.core.starter.config.HomeKitConfig;
import cn.ximcloud.homekit.core.starter.core.adapter.HomeKitDataSourceAdapter;
import cn.ximcloud.homekit.core.starter.core.adapter.HomeKitServiceAdapter;
import cn.ximcloud.homekit.core.starter.core.service.HomeKitService;
import cn.ximcloud.homekit.core.starter.utils.QrToConsole;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitRoot;
import io.github.hapjava.server.impl.HomekitServer;
import io.github.hapjava.server.impl.crypto.HAPSetupCodeUtils;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

/**
 * @author wizard
 */
@Slf4j
@Service
@Configuration
@AutoConfigureAfter(value = {HomeKitConfig.class, HomeKitDataSourceAdapter.class, HomeKitServiceAdapter.class})
public class HomeKitBootStrapServer implements InitializingBean, DisposableBean {

    private final HomeKitConfig homeKitConfig;

    private final HomeKitService homeKitService;

    private HomekitRoot homekitRoot;


    public HomeKitBootStrapServer(HomeKitConfig homeKitConfig, HomeKitService homeKitService) {
        this.homeKitConfig = homeKitConfig;
        this.homeKitService = homeKitService;
    }

    @SneakyThrows
    private static void printAccessoryLog(HomekitAccessory accessory) {
        log.info("add accessory [Id:{},Name:{},SerialNumber:{},Model:{},Manufacturer:{},FirmwareRevision:{}]",
                accessory.getId(), accessory.getName().get(), accessory.getSerialNumber().get(),
                accessory.getModel().get(), accessory.getManufacturer().get(), accessory.getFirmwareRevision().get());
    }

    /**
     * Invoked by the containing {@code BeanFactory} on destruction of a bean.
     */
    @Override
    public void destroy() {
        homekitRoot.stop();
    }

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties
     * and satisfied {@link BeanFactoryAware}, {@code ApplicationContextAware} etc.
     * <p>This method allows the bean instance to perform validation of its overall
     * configuration and final initialization when all bean properties have been set.
     */
    @SneakyThrows
    @Override
    public void afterPropertiesSet() {
        HomekitAuthInfo ximCloudHomeKitServiceAuthInfo = homeKitService.getAuthInfo();
        HomekitServer homeKit = new HomekitServer(homeKitConfig.getPort());
        this.homekitRoot = homeKit.createBridge(
                ximCloudHomeKitServiceAuthInfo,
                homeKitConfig.getLabel(),
                homeKitConfig.getManufacturer(),
                homeKitConfig.getModel(),
                homeKitConfig.getSerialNumber(),
                homeKitConfig.getFirmwareRevision(),
                homeKitConfig.getHardwareRevision()
        );
        homeKitService.getAccessoryList()
                .stream()
                .peek(HomeKitBootStrapServer::printAccessoryLog)
                .forEach(homekitRoot::addAccessory);
        homekitRoot.start();

        printQr(ximCloudHomeKitServiceAuthInfo);
    }

    private void printQr(HomekitAuthInfo ximCloudHomeKitAuthInfo) {
        String replace = ximCloudHomeKitAuthInfo.getPin().replace("-", "");
        String setupId = ximCloudHomeKitAuthInfo.getSetupId();
        String setupUri = HAPSetupCodeUtils.getSetupURI(replace, setupId, 2);
        log.info(QrToConsole.transformQr(setupUri));
        log.debug("pin:{},setupId:{},QR Url:{}", replace, setupId, setupUri);
    }
}
