package cn.ximcloud.homekit.core.starter.auth;

import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitServer;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * XIMCloudHomeKitAuthInfo
 *
 * @author W9004844
 */
@Data
@Slf4j
@AllArgsConstructor
public class BaseOnDataBaseHomeKitAuthInfo implements HomekitAuthInfo {

    /**
     * pin
     */
    private String pin;

    /**
     * mac
     */
    private String mac;

    /**
     * salt
     */
    private BigInteger salt;

    /**
     * privateKey
     */
    private byte[] privateKey;

    /**
     * userKeyMap
     */
    private Map<String, byte[]> userKeyMap = new ConcurrentHashMap<>();

    @SneakyThrows
    public BaseOnDataBaseHomeKitAuthInfo() {
        pin = HomekitServer.generatePin();
        mac = HomekitServer.generateMac();
        salt = HomekitServer.generateSalt();
        privateKey = HomekitServer.generateKey();
        log.info("The PIN for pairing is {}", pin);
    }

    @Override
    public void createUser(String username, byte[] publicKey) {
        if (!userKeyMap.containsKey(username)) {
            userKeyMap.putIfAbsent(username, publicKey);
            log.info("Added user for {}", username);
        } else {
            log.warn("Already have a user for {}", username);
        }
    }

    @Override
    public void removeUser(String username) {
        if (userKeyMap.containsKey(username)) {
            userKeyMap.remove(username);
            log.info("Removed pairing for {}", username);
        } else {
            log.warn("not have a user for {}", username);
        }
    }

    @Override
    public byte[] getUserPublicKey(String username) {
        if (userKeyMap.containsKey(username)) {
            return userKeyMap.get(username);
        } else {
            log.warn("not have a user for {}", username);
            return new byte[0];
        }
    }

}
