package cn.ximcloud.homekit.core.starter.util;

import cn.ximcloud.homekit.core.starter.constants.PlatformEnum;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ShutdownUtil {

    private static final String windowsPlatform = "shutdown –s –t %d –m %s –c \"shutdown now\" -f";

    private ShutdownUtil() {
    }

    @SneakyThrows
    public static void shutdown(String ipAddress, PlatformEnum platform, long time) {
        switch (platform) {
            case LINUX:
                throw new RuntimeException();
            case WINDOWS:
                String command = String.format(windowsPlatform, time, ipAddress);
                log.debug("command :{}", command);
                Process exec = Runtime.getRuntime().exec(command);
                System.out.println(exec.exitValue());
                break;
            case MACOS:
                break;
            default:
                throw new IllegalArgumentException();
        }
    }

}
